package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.MedicalExaminationData;
import org.msh.tb.entities.MedicalExamination;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.YesNoType;
import org.msh.tb.ng.entities.MedicalExaminationNG;

/**
 * Created by rmemoria on 13/9/17.
 */
public class MedicalExaminationConsumer extends SyncDataConsumerImpl<MedicalExaminationData, Integer> {

    @Override
    public Integer consume(Tbunit unit, MedicalExaminationData data) {
        MedicalExaminationNG exam = recoverEntity(MedicalExaminationNG.class, data.getServerId());

        if (exam.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            exam.setTbcase(tbcase);
        }

        exam.setDate(data.getDate());
        exam.setWeight(data.getWeight());
        exam.setHeight(data.getHeight());
        exam.setAppointmentType(data.getAppointmentType());
        if (data.getUsingPrescMedicines() != null) {
            exam.setUsingPrescMedicines(data.getUsingPrescMedicines().booleanValue() ? YesNoType.YES : YesNoType.NO);
        }
        exam.setReasonNotUsingPrescMedicines(data.getReasonNotUsingPrescMedicines());
        exam.setResponsible(data.getResponsible());
        exam.setQualification(data.getQualification());
        exam.setOtherQualifiedProfessional(data.getOtherQualifiedProfessional());
        if (data.getNutrtnSupport() != null) {
            exam.setNutrtnSupport(data.getNutrtnSupport().booleanValue() ? YesNoType.YES : YesNoType.NO);
        }
        exam.setPatientRefBy(data.getPatientRefBy());
        exam.setReferredByUnitName(data.getReferredByUnitName());
        exam.setRefByDate(data.getRefByDate());
        if (data.getPatientReferred() != null) {
            exam.setPatientReferred(data.getPatientReferred().booleanValue() ? YesNoType.YES : YesNoType.NO);
        }
        exam.setReferredToUnitName(data.getReferredToUnitName());
        exam.setSideeffect(getFieldValue(data.getSideEffectId()));
        exam.setRefToDate(data.getRefToDate());
        exam.setComments(data.getComments());

        getEntityManager().persist(exam);


        return data.getServerId() == null ? exam.getId() : null;
    }
}
